/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.commands;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import qouteall.imm_ptl.core.commands.PortalCommand;
import qouteall.imm_ptl.core.commands.TimingFunctionArgumentType;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.portal.PortalState;
import qouteall.imm_ptl.core.portal.animation.AnimationView;
import qouteall.imm_ptl.core.portal.animation.DeltaUnilateralPortalState;
import qouteall.imm_ptl.core.portal.animation.NormalAnimation;
import qouteall.imm_ptl.core.portal.animation.PortalAnimation;
import qouteall.imm_ptl.core.portal.animation.PortalAnimationDriver;
import qouteall.imm_ptl.core.portal.animation.RotationAnimation;
import qouteall.imm_ptl.core.portal.animation.TimingFunction;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.q_misc_util.my_util.Access;
import qouteall.q_misc_util.my_util.Vec2d;

public class PortalAnimationCommand {
    static void registerPortalAnimationCommands(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"clear").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            AnimationView animationView = portal.getAnimationView();
            animationView.getThisSideAnimations().clear();
            PortalCommand.reloadPortal(portal);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> PortalAnimationCommand.getAnimationInfo(portal), false);
        })));
        builder.then(Commands.m_82127_((String)"clear_both_sides").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            AnimationView animationView = portal.getAnimationView();
            animationView.getThisSideAnimations().clear();
            animationView.getOtherSideAnimations().clear();
            PortalCommand.reloadPortal(portal);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> PortalAnimationCommand.getAnimationInfo(portal), false);
        })));
        builder.then(Commands.m_82127_((String)"pause").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            PortalExtension.forClusterPortals(portal, Portal::pauseAnimation);
            PortalCommand.reloadPortal(portal);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Paused"), false);
        })));
        builder.then(Commands.m_82127_((String)"resume").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            PortalExtension.forClusterPortals(portal, Portal::resumeAnimation);
            PortalCommand.reloadPortal(portal);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Resumed"), false);
        })));
        builder.then(Commands.m_82127_((String)"all_pause").executes(context -> {
            ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
            for (Entity entity : level.m_8583_()) {
                if (!(entity instanceof Portal)) continue;
                Portal portal = (Portal)entity;
                PortalExtension.forClusterPortals(portal, Portal::pauseAnimation);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Paused " + portal.toString())), false);
            }
            return 0;
        }));
        builder.then(Commands.m_82127_((String)"view").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> ((CommandSourceStack)context.getSource()).m_288197_(() -> PortalAnimationCommand.getAnimationInfo(portal), false))));
        builder.then(Commands.m_82127_((String)"remove_at").then(Commands.m_82129_((String)"index", (ArgumentType)IntegerArgumentType.integer()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            int index = IntegerArgumentType.getInteger((CommandContext)context, (String)"index");
            AnimationView animationView = portal.getAnimationView();
            List<PortalAnimationDriver> thisSideAnimations = animationView.getThisSideAnimations();
            if (index >= 0 && index < thisSideAnimations.size()) {
                thisSideAnimations.remove(index);
                PortalCommand.reloadPortal(portal);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> PortalAnimationCommand.getAnimationInfo(portal), false);
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Invalid index " + index)));
            }
        }))));
        builder.then(Commands.m_82127_((String)"remove_last").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            AnimationView animationView = portal.getAnimationView();
            List<PortalAnimationDriver> thisSideAnimations = animationView.getThisSideAnimations();
            if (!thisSideAnimations.isEmpty()) {
                thisSideAnimations.remove(thisSideAnimations.size() - 1);
                PortalCommand.reloadPortal(portal);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> PortalAnimationCommand.getAnimationInfo(portal), false);
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"No animation"));
            }
        })));
        builder.then(Commands.m_82127_((String)"rotate_infinitely").then(Commands.m_82129_((String)"rotationCenterEntity", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"rotationAxis", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).then(Commands.m_82129_((String)"degreesPerTick", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            Entity rotationCenterEntity = EntityArgument.m_91452_((CommandContext)context, (String)"rotationCenterEntity");
            Vec3 rotationCenter = rotationCenterEntity.m_20182_();
            Vec3 axis = Vec3Argument.m_120844_((CommandContext)context, (String)"rotationAxis").m_82541_();
            double angularVelocity = DoubleArgumentType.getDouble((CommandContext)context, (String)"degreesPerTick");
            PortalAnimationCommand.giveRotationAnimation(portal, rotationCenter, axis, angularVelocity);
            PortalCommand.reloadPortal(portal);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> PortalAnimationCommand.getAnimationInfo(portal), false);
        }))))));
        builder.then(Commands.m_82127_((String)"rotate_infinitely_random").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            Vec3 rotationCenter = ((CommandSourceStack)context.getSource()).m_81371_();
            Vec3 axis = new Vec3(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5).m_82541_();
            double angularVelocity = Math.random() * 3.0;
            PortalAnimationCommand.giveRotationAnimation(portal, rotationCenter, axis, angularVelocity);
            PortalCommand.reloadPortal(portal);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> PortalAnimationCommand.getAnimationInfo(portal), false);
        })));
        builder.then(Commands.m_82127_((String)"rotate_portals_infinitely").then(Commands.m_82129_((String)"portals", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"rotationCenter", (ArgumentType)Vec3Argument.m_120841_()).then(Commands.m_82129_((String)"axis", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).then(Commands.m_82129_((String)"degreesPerTick", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> {
            Portal portal;
            Collection portals = EntityArgument.m_91461_((CommandContext)context, (String)"portals");
            Vec3 rotationCenter = Vec3Argument.m_120844_((CommandContext)context, (String)"rotationCenter");
            Vec3 axis = Vec3Argument.m_120844_((CommandContext)context, (String)"axis").m_82541_();
            double angularVelocity = DoubleArgumentType.getDouble((CommandContext)context, (String)"degreesPerTick");
            for (Entity entity : portals) {
                if (entity instanceof Portal) {
                    portal = (Portal)entity;
                    PortalAnimationCommand.giveRotationAnimation(portal, rotationCenter, axis, angularVelocity);
                    PortalCommand.reloadPortal(portal);
                    continue;
                }
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"the entity is not a portal"));
            }
            for (Entity entity : portals) {
                if (!(entity instanceof Portal)) continue;
                portal = (Portal)entity;
                PortalCommand.reloadPortal(portal);
            }
            return 0;
        }))))));
        builder.then(Commands.m_82127_((String)"rotate_portals").then(Commands.m_82129_((String)"portals", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"rotationCenter", (ArgumentType)Vec3Argument.m_120841_()).then(Commands.m_82129_((String)"axis", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).then(Commands.m_82129_((String)"degrees", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.m_82129_((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10000)).executes(context -> {
            Portal portal;
            Collection portals = EntityArgument.m_91461_((CommandContext)context, (String)"portals");
            Vec3 rotationCenter = Vec3Argument.m_120844_((CommandContext)context, (String)"rotationCenter");
            Vec3 axis = Vec3Argument.m_120844_((CommandContext)context, (String)"axis").m_82541_();
            double degrees = DoubleArgumentType.getDouble((CommandContext)context, (String)"degrees");
            int duration = IntegerArgumentType.getInteger((CommandContext)context, (String)"duration");
            for (Entity entity : portals) {
                if (entity instanceof Portal) {
                    portal = (Portal)entity;
                    PortalState endingState = portal.getAnimationEndingState();
                    long currTime = portal.m_9236_().m_46467_();
                    portal.addThisSideAnimationDriver(new RotationAnimation.Builder().setInitialOffset(endingState.fromPos.m_82546_(rotationCenter)).setRotationAxis(axis).setDegreesPerTick(degrees / (double)duration).setStartGameTime(currTime).setEndGameTime(currTime + (long)duration).setTimingFunction(TimingFunction.sine).build());
                    PortalCommand.reloadPortal(portal);
                    continue;
                }
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"the entity is not a portal"));
            }
            for (Entity entity : portals) {
                if (!(entity instanceof Portal)) continue;
                portal = (Portal)entity;
                PortalCommand.reloadPortal(portal);
            }
            return 0;
        })))))));
        builder.then(Commands.m_82127_((String)"rotate_along_normal").then(Commands.m_82129_((String)"degreesPerTick", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            double angularVelocity = DoubleArgumentType.getDouble((CommandContext)context, (String)"degreesPerTick");
            PortalAnimationCommand.giveRotationAnimation(portal, portal.getOriginPos(), portal.getNormal(), angularVelocity);
            PortalCommand.reloadPortal(portal);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> PortalAnimationCommand.getAnimationInfo(portal), false);
        }))));
        builder.then(Commands.m_82127_((String)"expand_from_center").then(Commands.m_82129_((String)"durationTicks", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            int durationTicks = IntegerArgumentType.getInteger((CommandContext)context, (String)"durationTicks");
            double animationScale = 10.0;
            portal.addThisSideAnimationDriver(NormalAnimation.createSizeAnimation(portal, new Vec2d(1.0 / animationScale, 1.0 / animationScale), new Vec2d(1.0, 1.0), portal.getAnimationEffectiveTime(), durationTicks, TimingFunction.sine));
            PortalCommand.reloadPortal(portal);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> PortalAnimationCommand.getAnimationInfo(portal), false);
        }))));
        LiteralArgumentBuilder buildBuilder = Commands.m_82127_((String)"build");
        buildBuilder.then(Commands.m_82127_((String)"begin").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            Portal animationHolder = portal.getAnimationHolder();
            if (animationHolder != null && animationHolder != portal) {
                PortalAnimationCommand.sendAnimationHolderFailure((CommandContext<CommandSourceStack>)context, animationHolder);
                return;
            }
            PortalAnimation animation = portal.animation;
            animation.setPaused(portal, true);
            PortalState portalState = portal.getPortalState();
            assert (portalState != null);
            if (animation.thisSideReferenceState != null && animation.otherSideReferenceState != null) {
                PortalState newState = UnilateralPortalState.combine(animation.thisSideReferenceState, animation.otherSideReferenceState);
                portal.setPortalState(newState);
            } else {
                animation.thisSideReferenceState = UnilateralPortalState.extractThisSide(portalState);
                animation.otherSideReferenceState = UnilateralPortalState.extractOtherSide(portalState);
            }
            NormalAnimation newNormalAnimation = new NormalAnimation.Builder().phases(List.of()).loopCount(1).startingGameTime(portal.getAnimationEffectiveTime()).isBuilding(true).build();
            animation.thisSideAnimations.add(newNormalAnimation);
            animation.otherSideAnimations.add(newNormalAnimation);
            PortalCommand.reloadPortal(portal);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> PortalAnimationCommand.getAnimationInfo(portal), false);
        })));
        buildBuilder.then(Commands.m_82127_((String)"append_phase").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"durationTicks", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            int durationTicks = IntegerArgumentType.getInteger((CommandContext)context, (String)"durationTicks");
            PortalAnimationCommand.executeAppendPhase((CommandContext<CommandSourceStack>)context, portal, durationTicks, TimingFunction.sine);
        }))).then(Commands.m_82129_((String)"timingFunction", (ArgumentType)TimingFunctionArgumentType.instance).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            int durationTicks = IntegerArgumentType.getInteger((CommandContext)context, (String)"durationTicks");
            TimingFunction timingFunction = TimingFunctionArgumentType.get((CommandContext<CommandSourceStack>)context, "timingFunction");
            PortalAnimationCommand.executeAppendPhase((CommandContext<CommandSourceStack>)context, portal, durationTicks, timingFunction);
        })))));
        buildBuilder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"finish").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> PortalAnimationCommand.finishBuildingNormalAnimation((CommandContext<CommandSourceStack>)context, portal, 100000)))).then(Commands.m_82129_((String)"loopCount", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100000)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            int loopCount = IntegerArgumentType.getInteger((CommandContext)context, (String)"loopCount");
            PortalAnimationCommand.finishBuildingNormalAnimation((CommandContext<CommandSourceStack>)context, portal, loopCount);
        }))));
        buildBuilder.then(Commands.m_82127_((String)"jump_to_phase").then(Commands.m_82129_((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100000)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            int index = IntegerArgumentType.getInteger((CommandContext)context, (String)"index");
            Portal animationHolder = portal.getAnimationHolder();
            if (animationHolder != null && animationHolder != portal) {
                PortalAnimationCommand.sendAnimationHolderFailure((CommandContext<CommandSourceStack>)context, animationHolder);
                return;
            }
            PortalAnimation animation = portal.animation;
            AnimationBuilderContext animationBuilderContext = PortalAnimationCommand.getAnimationBuilderContext(portal);
            if (animationBuilderContext == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"No animation to build"));
                return;
            }
            NormalAnimation thisSideAnimation = animationBuilderContext.thisSideAnimation().get();
            List<NormalAnimation.Phase> phases = thisSideAnimation.phases;
            if (index >= phases.size()) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Index out of range"));
                return;
            }
            long totalTicksBefore = phases.stream().limit(index + 1).mapToLong(p -> p.durationTicks()).sum();
            long newStartingGameTime = portal.getAnimationEffectiveTime() - totalTicksBefore;
            animationBuilderContext.thisSideAnimation().set(new NormalAnimation.Builder().from(animationBuilderContext.thisSideAnimation().get()).startingGameTime(newStartingGameTime).isBuilding(false).build());
            animationBuilderContext.otherSideAnimation().set(new NormalAnimation.Builder().from(animationBuilderContext.otherSideAnimation().get()).startingGameTime(newStartingGameTime).isBuilding(false).build());
            PortalCommand.reloadPortal(portal);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> PortalAnimationCommand.getAnimationInfo(portal), false);
        }))));
        builder.then((ArgumentBuilder)buildBuilder);
    }

    private static void executeAppendPhase(CommandContext<CommandSourceStack> context, Portal portal, int durationTicks, TimingFunction timingFunction) {
        Portal animationHolder = portal.getAnimationHolder();
        if (animationHolder != null && animationHolder != portal) {
            PortalAnimationCommand.sendAnimationHolderFailure(context, animationHolder);
            return;
        }
        PortalAnimation animation = portal.animation;
        AnimationBuilderContext animationBuilderContext = PortalAnimationCommand.getAnimationBuilderContext(portal);
        if (animationBuilderContext == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"No animation to build"));
            return;
        }
        PortalState currentPortalState = portal.getPortalState();
        assert (currentPortalState != null);
        UnilateralPortalState thisSideReferenceState = animation.thisSideReferenceState;
        UnilateralPortalState otherSideReferenceState = animation.otherSideReferenceState;
        if (thisSideReferenceState == null || otherSideReferenceState == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"No reference state"));
            return;
        }
        DeltaUnilateralPortalState thisSideDelta = UnilateralPortalState.extractThisSide(currentPortalState).subtract(thisSideReferenceState);
        DeltaUnilateralPortalState otherSideDelta = UnilateralPortalState.extractOtherSide(currentPortalState).subtract(otherSideReferenceState);
        NormalAnimation thisSideAnimation = animationBuilderContext.thisSideAnimation().get();
        animationBuilderContext.thisSideAnimation().set(new NormalAnimation.Builder().phases((List<NormalAnimation.Phase>)ImmutableList.builder().addAll(thisSideAnimation.phases).add((Object)new NormalAnimation.Phase.Builder().durationTicks(durationTicks).timingFunction(timingFunction).delta(thisSideDelta).build()).build()).loopCount(thisSideAnimation.loopCount).startingGameTime(thisSideAnimation.startingGameTime).isBuilding(true).build());
        NormalAnimation otherSideAnimation = animationBuilderContext.otherSideAnimation().get();
        animationBuilderContext.otherSideAnimation().set(new NormalAnimation.Builder().phases((List<NormalAnimation.Phase>)ImmutableList.builder().addAll(otherSideAnimation.phases).add((Object)new NormalAnimation.Phase.Builder().durationTicks(durationTicks).timingFunction(timingFunction).delta(otherSideDelta).build()).build()).loopCount(otherSideAnimation.loopCount).startingGameTime(otherSideAnimation.startingGameTime).isBuilding(true).build());
        PortalCommand.reloadPortal(portal);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> PortalAnimationCommand.getAnimationInfo(portal), false);
    }

    private static AnimationBuilderContext getAnimationBuilderContext(Portal portal) {
        final PortalAnimation animation = portal.animation;
        if (animation.thisSideAnimations.isEmpty() || animation.otherSideAnimations.isEmpty()) {
            return null;
        }
        final int thisSideIndex = animation.thisSideAnimations.size() - 1;
        PortalAnimationDriver lastThisSideAnimation = animation.thisSideAnimations.get(thisSideIndex);
        if (!(lastThisSideAnimation instanceof NormalAnimation)) {
            return null;
        }
        final NormalAnimation thisSideNormalAnimation = (NormalAnimation)lastThisSideAnimation;
        final int otherSideIndex = animation.otherSideAnimations.size() - 1;
        PortalAnimationDriver lastOtherSideAnimation = animation.otherSideAnimations.get(otherSideIndex);
        if (!(lastOtherSideAnimation instanceof NormalAnimation)) {
            return null;
        }
        final NormalAnimation otherSideNormalAnimation = (NormalAnimation)lastOtherSideAnimation;
        return new AnimationBuilderContext(portal, new Access<NormalAnimation>(){

            @Override
            public NormalAnimation get() {
                return thisSideNormalAnimation;
            }

            @Override
            public void set(NormalAnimation normalAnimation) {
                animation.thisSideAnimations.set(thisSideIndex, normalAnimation);
            }
        }, new Access<NormalAnimation>(){

            @Override
            public NormalAnimation get() {
                return otherSideNormalAnimation;
            }

            @Override
            public void set(NormalAnimation normalAnimation) {
                animation.otherSideAnimations.set(otherSideIndex, normalAnimation);
            }
        });
    }

    private static void sendAnimationHolderFailure(CommandContext<CommandSourceStack> context, Portal animationHolder) {
        ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("This portal entity is not animation holder. Use this command to " + String.valueOf(animationHolder))));
    }

    private static void finishBuildingNormalAnimation(CommandContext<CommandSourceStack> context, Portal portal, int loopCount) {
        Portal animationHolder = portal.getAnimationHolder();
        if (animationHolder != null && animationHolder != portal) {
            PortalAnimationCommand.sendAnimationHolderFailure(context, animationHolder);
            return;
        }
        PortalAnimation animation = portal.animation;
        AnimationBuilderContext animationBuilderContext = PortalAnimationCommand.getAnimationBuilderContext(portal);
        if (animationBuilderContext == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"No animation to build"));
            return;
        }
        ImmutableList thisSidePhases = animationBuilderContext.thisSideAnimation().get().phases;
        ImmutableList otherSidePhases = animationBuilderContext.otherSideAnimation().get().phases;
        if (thisSidePhases.isEmpty() || otherSidePhases.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"No phase"));
            return;
        }
        NormalAnimation.Phase lastThisSidePhase = thisSidePhases.get(thisSidePhases.size() - 1);
        DeltaUnilateralPortalState lastThisSidePhaseDelta = lastThisSidePhase.delta().purgeFPError();
        NormalAnimation.Phase lastOtherSidePhase = otherSidePhases.get(otherSidePhases.size() - 1);
        DeltaUnilateralPortalState lastOtherSidePhaseDelta = lastOtherSidePhase.delta().purgeFPError();
        if (loopCount > 1 && !lastThisSidePhaseDelta.isIdentity() || !lastOtherSidePhaseDelta.isIdentity()) {
            thisSidePhases = ImmutableList.builder().addAll(thisSidePhases).add((Object)new NormalAnimation.Phase.Builder().durationTicks(5L).timingFunction(TimingFunction.sine).delta(DeltaUnilateralPortalState.identity).build()).build();
            otherSidePhases = ImmutableList.builder().addAll(otherSidePhases).add((Object)new NormalAnimation.Phase.Builder().durationTicks(5L).timingFunction(TimingFunction.sine).delta(DeltaUnilateralPortalState.identity).build()).build();
        }
        animationBuilderContext.thisSideAnimation().set(new NormalAnimation.Builder().phases((List<NormalAnimation.Phase>)thisSidePhases).loopCount(loopCount).startingGameTime(animationBuilderContext.thisSideAnimation().get().startingGameTime).build());
        animationBuilderContext.otherSideAnimation().set(new NormalAnimation.Builder().phases((List<NormalAnimation.Phase>)otherSidePhases).loopCount(loopCount).startingGameTime(animationBuilderContext.otherSideAnimation().get().startingGameTime).build());
        animation.setBackToPausingState(portal);
        animation.setPaused(portal, false);
        PortalExtension.forClusterPortals(portal, Portal::reloadAndSyncToClientNextTick);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> PortalAnimationCommand.getAnimationInfo(portal), false);
    }

    private static void giveRotationAnimation(Portal portal, Vec3 rotationCenter, Vec3 axis, double angularVelocity) {
        portal.addThisSideAnimationDriver(new RotationAnimation.Builder().setInitialOffset(portal.getOriginPos().m_82546_(rotationCenter)).setRotationAxis(axis).setDegreesPerTick(angularVelocity).setStartGameTime(portal.getAnimationEffectiveTime()).setEndGameTime(Long.MAX_VALUE).build());
    }

    private static Component getAnimationInfo(Portal portal) {
        return portal.getAnimationView().getInfo();
    }

    public record AnimationBuilderContext(Portal portal, Access<NormalAnimation> thisSideAnimation, Access<NormalAnimation> otherSideAnimation) {
    }
}

